package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressStatus describe the current state of the Ingress. */
final case class IngressStatus(
  loadBalancer : Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
) {

  /** Returns a new data with loadBalancer set to new value */
  def withLoadBalancer(value: io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = Some(value))
  /** if loadBalancer has a value, transforms to the result of function*/
  def mapLoadBalancer(f: io.k8s.api.core.v1.LoadBalancerStatus => io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = loadBalancer.map(f))
}

object IngressStatus {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressStatus] = new Encoder[io.k8s.api.networking.v1.IngressStatus] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("loadBalancer", o.loadBalancer)
            .build
        }
    }

    implicit val decoder: Decoder[IngressStatus] = new Decoder[IngressStatus] {
      def apply[T : Reader](t: T): Either[String, IngressStatus] = for {
          obj <- ObjectReader(t)
          loadBalancer <- obj.readOpt[io.k8s.api.core.v1.LoadBalancerStatus]("loadBalancer")
      } yield IngressStatus (
          loadBalancer = loadBalancer
        )
    }
}

