package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** NetworkPolicyPort describes a port to allow traffic on */
final case class NetworkPolicyPort(
  endPort : Option[Int] = None,
  port : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  protocol : Option[String] = None
) {

  /** Returns a new data with endPort set to new value */
  def withEndPort(value: Int) : NetworkPolicyPort = copy(endPort = Some(value))
  /** if endPort has a value, transforms to the result of function*/
  def mapEndPort(f: Int => Int) : NetworkPolicyPort = copy(endPort = endPort.map(f))

  /** Returns a new data with port set to new value */
  def withPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : NetworkPolicyPort = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : NetworkPolicyPort = copy(port = port.map(f))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : NetworkPolicyPort = copy(protocol = Some(value))
  /** if protocol has a value, transforms to the result of function*/
  def mapProtocol(f: String => String) : NetworkPolicyPort = copy(protocol = protocol.map(f))
}

object NetworkPolicyPort {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyPort] = new Encoder[io.k8s.api.networking.v1.NetworkPolicyPort] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.NetworkPolicyPort) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("endPort", o.endPort)
            .write("port", o.port)
            .write("protocol", o.protocol)
            .build
        }
    }

    implicit val decoder: Decoder[NetworkPolicyPort] = new Decoder[NetworkPolicyPort] {
      def apply[T : Reader](t: T): Either[String, NetworkPolicyPort] = for {
          obj <- ObjectReader(t)
          endPort <- obj.readOpt[Int]("endPort")
          port <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("port")
          protocol <- obj.readOpt[String]("protocol")
      } yield NetworkPolicyPort (
          endPort = endPort,
          port = port,
          protocol = protocol
        )
    }
}

