package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject. */
final case class ClusterRoleBinding(
  roleRef : io.k8s.api.rbac.v1.RoleRef,
  subjects : Option[Seq[io.k8s.api.rbac.v1.Subject]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleBinding", "v1")


  /** Returns a new data with roleRef set to new value */
  def withRoleRef(value: io.k8s.api.rbac.v1.RoleRef) : ClusterRoleBinding = copy(roleRef = value)
  /** transforms roleRef to result of function */
  def mapRoleRef(f: io.k8s.api.rbac.v1.RoleRef => io.k8s.api.rbac.v1.RoleRef) : ClusterRoleBinding = copy(roleRef = f(roleRef))

  /** Returns a new data with subjects set to new value */
  def withSubjects(value: Seq[io.k8s.api.rbac.v1.Subject]) : ClusterRoleBinding = copy(subjects = Some(value))
  /** Appends new values to subjects */
  def addSubjects(newValues: io.k8s.api.rbac.v1.Subject*) : ClusterRoleBinding = copy(subjects = Some(subjects.fold(newValues)(_ ++ newValues)))
  /** if subjects has a value, transforms to the result of function*/
  def mapSubjects(f: Seq[io.k8s.api.rbac.v1.Subject] => Seq[io.k8s.api.rbac.v1.Subject]) : ClusterRoleBinding = copy(subjects = subjects.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRoleBinding = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRoleBinding = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterRoleBinding.encoder.apply(this)
}

object ClusterRoleBinding {

    implicit val encoder : Encoder[io.k8s.api.rbac.v1.ClusterRoleBinding] = new Encoder[io.k8s.api.rbac.v1.ClusterRoleBinding] {
        def apply[T : Builder](o: io.k8s.api.rbac.v1.ClusterRoleBinding) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("roleRef", o.roleRef)
            .write("subjects", o.subjects)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterRoleBinding] = new Decoder[ClusterRoleBinding] {
      def apply[T : Reader](t: T): Either[String, ClusterRoleBinding] = for {
          obj <- ObjectReader(t)
          roleRef <- obj.read[io.k8s.api.rbac.v1.RoleRef]("roleRef")
          subjects <- obj.readOpt[Seq[io.k8s.api.rbac.v1.Subject]]("subjects")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ClusterRoleBinding (
          roleRef = roleRef,
          subjects = subjects,
          metadata = metadata
        )
    }
}

