package io.k8s.api.storage.v1beta1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CSIStorageCapacityList is a collection of CSIStorageCapacity objects. */
final case class CSIStorageCapacityList(
  items : Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIStorageCapacityList", "v1beta1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity]) : CSIStorageCapacityList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1beta1.CSIStorageCapacity*) : CSIStorageCapacityList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity] => Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity]) : CSIStorageCapacityList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIStorageCapacityList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIStorageCapacityList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CSIStorageCapacityList.encoder.apply(this)
}

object CSIStorageCapacityList {

    implicit val encoder : Encoder[io.k8s.api.storage.v1beta1.CSIStorageCapacityList] = new Encoder[io.k8s.api.storage.v1beta1.CSIStorageCapacityList] {
        def apply[T : Builder](o: io.k8s.api.storage.v1beta1.CSIStorageCapacityList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[CSIStorageCapacityList] = new Decoder[CSIStorageCapacityList] {
      def apply[T : Reader](t: T): Either[String, CSIStorageCapacityList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CSIStorageCapacityList (
          items = items,
          metadata = metadata
        )
    }
}

