package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis. */
final case class APIGroupList(
  groups : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIGroupList", "v1")


  /** Returns a new data with groups set to new value */
  def withGroups(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]) : APIGroupList = copy(groups = value)
  /** Appends new values to groups */
  def addGroups(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup*) : APIGroupList = copy(groups = groups ++ newValues)
  /** transforms groups to result of function */
  def mapGroups(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]) : APIGroupList = copy(groups = f(groups))

  override def foldTo[T : Builder] : T = APIGroupList.encoder.apply(this)
}

object APIGroupList {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("groups", o.groups)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[APIGroupList] = new Decoder[APIGroupList] {
      def apply[T : Reader](t: T): Either[String, APIGroupList] = for {
          obj <- ObjectReader(t)
          groups <- obj.read[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]]("groups")
      } yield APIGroupList (
          groups = groups
        )
    }
}

