package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered. */
final case class StatusCause(
  field : Option[String] = None,
  message : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with field set to new value */
  def withField(value: String) : StatusCause = copy(field = Some(value))
  /** if field has a value, transforms to the result of function*/
  def mapField(f: String => String) : StatusCause = copy(field = field.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : StatusCause = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : StatusCause = copy(message = message.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : StatusCause = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : StatusCause = copy(reason = reason.map(f))
}

object StatusCause {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("field", o.field)
            .write("message", o.message)
            .write("reason", o.reason)
            .build
        }
    }

    implicit val decoder: Decoder[StatusCause] = new Decoder[StatusCause] {
      def apply[T : Reader](t: T): Either[String, StatusCause] = for {
          obj <- ObjectReader(t)
          field <- obj.readOpt[String]("field")
          message <- obj.readOpt[String]("message")
          reason <- obj.readOpt[String]("reason")
      } yield StatusCause (
          field = field,
          message = message,
          reason = reason
        )
    }
}

