package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s.utils._

/** APIServiceStatus contains derived information about an API server */
final case class APIServiceStatus(
  conditions : Option[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]) : APIServiceStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition*) : APIServiceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition] => Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]) : APIServiceStatus = copy(conditions = conditions.map(f))
}

object APIServiceStatus {

    implicit val encoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = new Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] {
        def apply[T : Builder](o: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .build
        }
    }

    implicit val decoder: Decoder[APIServiceStatus] = new Decoder[APIServiceStatus] {
      def apply[T : Reader](t: T): Either[String, APIServiceStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]]("conditions")
      } yield APIServiceStatus (
          conditions = conditions
        )
    }
}

