/*
 * Decompiled with CFR 0.152.
 */
package qio.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import qio.Qio;
import qio.annotate.Inject;
import qio.annotate.Property;
import qio.model.support.ObjectDetails;

public class AnnotationProcessor {
    Qio qio;
    Map<String, ObjectDetails> processed;
    List<ObjectDetails> annotations;

    public AnnotationProcessor(Qio qio) {
        this.qio = qio;
        this.processed = new HashMap<String, ObjectDetails>();
        this.annotations = new ArrayList<ObjectDetails>();
        this.map();
    }

    public void run() throws Exception {
        if (!this.allAnnotationsProcessed().booleanValue()) {
            this.processAnnotations(0);
        }
    }

    private void processAnnotations(int idx) throws Exception {
        if (idx > this.annotations.size()) {
            idx = 0;
        }
        Integer z = idx;
        while (z < this.annotations.size()) {
            Field[] fields;
            ObjectDetails objectDetails = this.annotations.get(z);
            Integer fieldsCount = this.getAnnotatedFieldsCount(objectDetails.getClazz());
            Integer processedFieldsCount = 0;
            Object object = objectDetails.getObject();
            for (Field field : fields = objectDetails.getClazz().getDeclaredFields()) {
                Integer n;
                if (field.isAnnotationPresent(Inject.class)) {
                    String fieldKey = field.getName().toLowerCase();
                    if (this.qio.getElementStorage().getElements().containsKey(fieldKey)) {
                        Object element = this.qio.getElementStorage().getElements().get(fieldKey).getElement();
                        field.setAccessible(true);
                        field.set(object, element);
                        Integer n2 = processedFieldsCount;
                        n = processedFieldsCount = Integer.valueOf(processedFieldsCount + 1);
                    } else {
                        this.processAnnotations(z + 1);
                    }
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                String key = annotation.value();
                if (this.qio.getPropertyStorage().getProperties().containsKey(key)) {
                    String value = this.qio.getPropertyStorage().getProperties().get(key);
                    field.setAccessible(true);
                    field.set(object, value);
                    n = processedFieldsCount;
                    Integer n3 = processedFieldsCount = Integer.valueOf(processedFieldsCount + 1);
                    continue;
                }
                this.processAnnotations(z + 1);
                throw new Exception(field.getName() + " is missing on " + object.getClass().getName());
            }
            if (fieldsCount != processedFieldsCount) {
                this.processAnnotations(z + 1);
            } else {
                String key = Qio.getName(objectDetails.getName());
                this.processed.put(key, objectDetails);
            }
            Integer n = z;
            Integer n4 = z = Integer.valueOf(z + 1);
        }
    }

    protected Integer getAnnotatedFieldsCount(Class clazz) throws Exception {
        Field[] fields;
        Integer count = 0;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Integer n;
            Integer n2;
            if (field.isAnnotationPresent(Inject.class)) {
                n2 = count;
                n = count = Integer.valueOf(count + 1);
            }
            if (!field.isAnnotationPresent(Property.class)) continue;
            n2 = count;
            n = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    private void map() {
        for (Map.Entry<String, ObjectDetails> entry : this.qio.getElementProcessor().getAnnotatedClasses().entrySet()) {
            ObjectDetails objectDetails = entry.getValue();
            if (this.annotations.contains(objectDetails)) continue;
            this.annotations.add(objectDetails);
        }
    }

    protected Boolean allAnnotationsProcessed() {
        return this.processed.size() == this.qio.getElementProcessor().getAnnotatedClasses().size();
    }
}

