/*
 * Decompiled with CFR 0.152.
 */
package qio.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import qio.Qio;
import qio.annotate.Config;
import qio.annotate.DataStore;
import qio.annotate.HttpHandler;
import qio.annotate.Inject;
import qio.annotate.Property;
import qio.annotate.Service;
import qio.model.Element;
import qio.model.support.ObjectDetails;

public class ElementProcessor {
    Qio qio;
    Integer jdbcCount;
    Integer serviceCount;
    Integer elementCount;
    List<Class> configs;
    Map<String, ObjectDetails> httpClasses;
    Map<String, ObjectDetails> annotatedClasses;

    public ElementProcessor(Qio qio) {
        this.qio = qio;
        this.jdbcCount = 0;
        this.serviceCount = 0;
        this.elementCount = 0;
        this.configs = new ArrayList<Class>();
        this.httpClasses = new HashMap<String, ObjectDetails>();
        this.annotatedClasses = new HashMap<String, ObjectDetails>();
    }

    public ElementProcessor run() {
        Class<?> cls;
        for (Map.Entry<String, ObjectDetails> entry : this.qio.getObjects().entrySet()) {
            cls = entry.getValue().getClazz();
            if (!cls.isAnnotationPresent(Config.class)) continue;
            this.configs.add(cls);
        }
        for (Map.Entry<String, ObjectDetails> entry : this.qio.getObjects().entrySet()) {
            Field[] fields;
            Integer n;
            cls = entry.getValue().getClazz();
            if (cls.isAnnotationPresent(qio.annotate.Element.class)) {
                this.buildAddElement(entry);
                n = this.elementCount;
                Integer n2 = this.elementCount = Integer.valueOf(this.elementCount + 1);
            }
            if (cls.isAnnotationPresent(DataStore.class)) {
                this.buildAddElement(entry);
                n = this.jdbcCount;
                Integer n3 = this.jdbcCount = Integer.valueOf(this.jdbcCount + 1);
            }
            if (cls.isAnnotationPresent(Service.class)) {
                this.buildAddElement(entry);
                n = this.serviceCount;
                Integer n4 = this.serviceCount = Integer.valueOf(this.serviceCount + 1);
            }
            if (cls.isAnnotationPresent(HttpHandler.class)) {
                this.httpClasses.put(entry.getKey(), entry.getValue());
            }
            for (Field field : fields = cls.getDeclaredFields()) {
                if (field.isAnnotationPresent(Inject.class)) {
                    this.annotatedClasses.put(entry.getKey(), entry.getValue());
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                this.annotatedClasses.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Map<String, ObjectDetails> getHttpClasses() {
        return this.httpClasses;
    }

    public Map<String, ObjectDetails> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public List<Class> getConfigs() {
        return this.configs;
    }

    protected void buildAddElement(Map.Entry<String, ObjectDetails> entry) {
        Element element = new Element();
        String key = entry.getKey();
        Object object = entry.getValue().getObject();
        element.setElement(object);
        this.qio.getElementStorage().getElements().put(key, element);
    }
}

