/*
 * Decompiled with CFR 0.152.
 */
package qio.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import qio.Qio;
import qio.annotate.Variable;
import qio.annotate.verbs.Delete;
import qio.annotate.verbs.Get;
import qio.annotate.verbs.Post;
import qio.annotate.verbs.Put;
import qio.model.support.ObjectDetails;
import qio.model.web.EndpointMapping;
import qio.model.web.EndpointMappings;
import qio.model.web.TypeFeature;

public class EndpointProcessor {
    public static final String GET = "Get";
    public static final String POST = "Post";
    public static final String PUT = "Put";
    public static final String DELETE = "Delete";
    Qio qio;
    Map<String, ObjectDetails> processed;
    EndpointMappings endpointMappings;

    public EndpointProcessor(Qio qio) {
        this.qio = qio;
        this.processed = new HashMap<String, ObjectDetails>();
        this.endpointMappings = new EndpointMappings();
    }

    public EndpointProcessor run() throws Exception {
        while (!this.allAnnotationsProcessed()) {
            this.processWebAnnotations();
        }
        return this;
    }

    private boolean allAnnotationsProcessed() {
        return this.processed.size() == this.qio.getElementProcessor().getHttpClasses().size();
    }

    private void processWebAnnotations() throws Exception {
        for (Map.Entry<String, ObjectDetails> entry : this.qio.getElementProcessor().getHttpClasses().entrySet()) {
            Method[] methods;
            Class<?> clazz = entry.getValue().getClazz();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Get.class)) {
                    this.setGetMapping(method, entry.getValue());
                    this.processed.put(entry.getKey(), entry.getValue());
                }
                if (method.isAnnotationPresent(Post.class)) {
                    this.setPostMapping(method, entry.getValue());
                    this.processed.put(entry.getKey(), entry.getValue());
                }
                if (method.isAnnotationPresent(Put.class)) {
                    this.setPutMapping(method, entry.getValue());
                    this.processed.put(entry.getKey(), entry.getValue());
                }
                if (!method.isAnnotationPresent(Delete.class)) continue;
                this.setDeleteMapping(method, entry.getValue());
                this.processed.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setGetMapping(Method method, ObjectDetails objectDetails) throws Exception {
        Get get = method.getAnnotation(Get.class);
        String path = get.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(GET);
        this.setBaseDetailsAdd(path, mapping, method, objectDetails);
    }

    protected void setPostMapping(Method method, ObjectDetails objectDetails) throws Exception {
        Post post = method.getAnnotation(Post.class);
        String path = post.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(POST);
        this.setBaseDetailsAdd(path, mapping, method, objectDetails);
    }

    protected void setPutMapping(Method method, ObjectDetails objectDetails) throws Exception {
        Put put = method.getAnnotation(Put.class);
        String path = put.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(PUT);
        this.setBaseDetailsAdd(path, mapping, method, objectDetails);
    }

    protected void setDeleteMapping(Method method, ObjectDetails objectDetails) throws Exception {
        Delete delete = method.getAnnotation(Delete.class);
        String path = delete.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(DELETE);
        this.setBaseDetailsAdd(path, mapping, method, objectDetails);
    }

    protected void setBaseDetailsAdd(String path, EndpointMapping mapping, Method method, ObjectDetails objectDetails) throws Exception {
        String[] parts;
        Type[] types;
        mapping.setTypeNames(new ArrayList<String>());
        for (Type type : types = method.getGenericParameterTypes()) {
            mapping.getTypeNames().add(type.getTypeName());
        }
        ArrayList<TypeFeature> typeDetails = new ArrayList<TypeFeature>();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int n = 0; n < paramAnnotations.length; ++n) {
            for (Annotation a : paramAnnotations[n]) {
                if (!(a instanceof Variable)) continue;
                TypeFeature details = new TypeFeature();
                details.setName(paramTypes[n].getTypeName());
                details.setType(paramTypes[n].getTypeName());
                typeDetails.add(details);
            }
        }
        StringBuilder regexPath = new StringBuilder();
        regexPath.append("\\/(");
        int count = 0;
        for (String part : parts = path.split("/")) {
            ++count;
            if (part.equals("")) continue;
            if (part.matches("(\\{\\{[a-zA-Z]*\\}\\})")) {
                regexPath.append("(.*[A-Za-z0-9])");
                mapping.getVariablePositions().add(count - 1);
            } else {
                regexPath.append("(" + part.toLowerCase() + "){1}");
            }
            if (count >= parts.length) continue;
            regexPath.append("\\/");
        }
        regexPath.append(")$");
        mapping.setRegexedPath(regexPath.toString());
        mapping.setTypeDetails(typeDetails);
        mapping.setPath(path);
        mapping.setMethod(method);
        mapping.setClassDetails(objectDetails);
        String key = mapping.getVerb().concat("-").concat(path);
        if (this.endpointMappings.contains(key)) {
            throw new Exception("Request path + " + path + " exists multiple times.");
        }
        this.endpointMappings.add(key, mapping);
    }

    public EndpointMappings getMappings() {
        return this.endpointMappings;
    }
}

