/*
 * Decompiled with CFR 0.152.
 */
package qio.processor;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import qio.Qio;
import qio.annotate.Events;
import qio.model.support.ObjectDetails;

public class InstanceProcessor {
    Qio qio;
    ClassLoader cl;
    Map<String, ObjectDetails> objects;

    public InstanceProcessor(Qio qio) {
        this.qio = qio;
        this.objects = new HashMap<String, ObjectDetails>();
        this.cl = Thread.currentThread().getContextClassLoader();
    }

    public InstanceProcessor run() throws Exception {
        Qio.command("        [+]   initializing dependencies");
        this.createClasses(this.qio.getClassesUri());
        return this;
    }

    protected void createClasses(String classesPath) {
        File[] files;
        File pathFile = new File(classesPath);
        for (File file : files = pathFile.listFiles()) {
            if (file.isDirectory()) {
                this.createClasses(file.getPath());
                continue;
            }
            try {
                Class<?> cls;
                String classPath;
                String[] pathParts;
                String regex;
                String separator;
                if (!file.toString().endsWith(".java") && !file.toString().endsWith(".class")) continue;
                if (file.toString().endsWith(".java")) {
                    separator = System.getProperty("file.separator");
                    regex = "java\\" + separator;
                    pathParts = file.getPath().split(regex);
                    classPath = pathParts[1].replace("\\", ".").replace("/", ".").replace(".java", "");
                    cls = this.cl.loadClass(classPath);
                } else {
                    separator = System.getProperty("file.separator");
                    regex = "classes\\" + separator;
                    pathParts = file.getPath().split(regex);
                    classPath = pathParts[1].replace("\\", ".").replace("/", ".").replace(".class", "");
                    cls = this.cl.loadClass(classPath);
                }
                if (cls.isAnnotation() || cls.isInterface() || cls.getName() == this.getClass().getName()) continue;
                if (cls.isAnnotationPresent(Events.class)) {
                    this.qio.setEvents(this.getObject(cls));
                }
                ObjectDetails objectDetails = new ObjectDetails();
                objectDetails.setClazz(cls);
                objectDetails.setName(Qio.getName(cls.getName()));
                Object object = this.getObject(cls);
                objectDetails.setObject(object);
                this.qio.getObjects().put(objectDetails.getName(), objectDetails);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected Object getObject(Class cls) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getDeclaredConstructors()) {
            constructor.setAccessible(true);
            if (constructor.getParameterCount() != 0) continue;
            return constructor.newInstance(new Object[0]);
        }
        return null;
    }
}

