/*
 * Decompiled with CFR 0.152.
 */
package qio.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import qio.Qio;

public class PropertiesProcessor {
    Qio qio;

    public PropertiesProcessor(Qio qio) {
        this.qio = qio;
    }

    protected File getPropertiesFile(String propertyFile) throws Exception {
        String resourceUri = this.qio.getResourceUri();
        File file = new File(resourceUri + File.separator + propertyFile);
        if (!file.exists()) {
            throw new Exception(propertyFile.concat(" properties file cannot be located..."));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        Qio.command("        [+]   resolving properties");
        if (this.qio.getPropertiesFiles() != null) {
            for (String propertyFile : this.qio.getPropertiesFiles()) {
                Properties prop = null;
                try (FileInputStream fis = null;){
                    File file = this.getPropertiesFile(propertyFile);
                    fis = new FileInputStream(file);
                    prop = new Properties();
                    prop.load(fis);
                    Enumeration<?> properties = prop.propertyNames();
                    while (properties.hasMoreElements()) {
                        String key = (String)properties.nextElement();
                        String value = prop.getProperty(key);
                        this.qio.getPropertyStorage().getProperties().put(key, value);
                    }
                }
            }
        }
    }
}

