/*
 * Decompiled with CFR 0.152.
 */
package qio.support;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import javax.sql.DataSource;
import org.h2.tools.RunScript;
import qio.Qio;

public class DbMediator {
    Qio qio;

    public DbMediator(Qio qio) {
        this.qio = qio;
    }

    public Boolean createDb() throws Exception {
        String artifactPath = Qio.getResourceUri(this.qio.servletContext);
        File createFile = new File(artifactPath + File.separator + this.qio.getDbScript());
        DataSource datasource = (DataSource)this.qio.getElement("datasource");
        if (datasource == null) {
            Qio.command("\n");
            throw new Exception("\n\n           You have qio.dev set to true in qio.props.\n           In addition you need to configure a datasource. \n           Feel free to use qio.jdbc.BasicDataSource to get started.\n           You can also checkout HikariCP, it is pretty good!\n\n           https://github.com/brettwooldridge/HikariCP\n\n\n");
        }
        Connection conn = datasource.getConnection();
        RunScript.execute((Connection)conn, (Reader)new FileReader(createFile));
        conn.commit();
        conn.close();
        return true;
    }

    public Boolean dropDb() {
        Qio.command("\n\n\n\n\n\n\n\n        //| \u001b[1;34m Q\u001b[0;30mio  cleaning dev env...\n");
        try {
            DataSource datasource = (DataSource)this.qio.getElement("datasource");
            Connection conn = datasource.getConnection();
            RunScript.execute((Connection)conn, (Reader)new StringReader("drop all objects;"));
            conn.commit();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

