/*
 * Decompiled with CFR 0.152.
 */
package qio.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sql.DataSource;
import qio.Qio;
import qio.model.Element;
import qio.model.web.EndpointMappings;
import qio.processor.AnnotationProcessor;
import qio.processor.ConfigurationProcessor;
import qio.processor.ElementProcessor;
import qio.processor.EndpointProcessor;
import qio.processor.InstanceProcessor;
import qio.processor.PropertiesProcessor;
import qio.support.DbMediator;

public class Initializer {

    public static class Builder {
        Qio qio;

        public Builder withQio(Qio qio) {
            this.qio = qio;
            return this;
        }

        private void setQioAttributes() {
            Element qioElement = new Element();
            qioElement.setElement(this.qio);
            this.qio.getElementStorage().getElements().put("qio", qioElement);
            Qio.set(this.qio.getElementStorage().getElements());
            this.qio.getServletContext().setAttribute("qio", (Object)qioElement);
            this.qio.getServletContext().setAttribute("qio-resources", this.qio.getResources());
            if (this.qio.getResources() == null) {
                this.qio.setResources(new ArrayList<String>());
            }
            if (this.qio.getPropertiesFiles() == null) {
                this.qio.setPropertiesFiles(new ArrayList<String>());
            }
        }

        private void checkInitDevDb() throws Exception {
            if (this.qio.inDevMode()) {
                DbMediator mediator = new DbMediator(this.qio);
                Element element = new Element();
                element.setElement(mediator);
                this.qio.getElementStorage().getElements().put("dbmediator", element);
                mediator.createDb();
            }
        }

        private void validateDatasource() throws Exception {
            System.out.println("        [+]   validating datasource");
            Element element = this.qio.getElementStorage().getElements().get("datasource");
            if (element != null) {
                DataSource dataSource = (DataSource)element.getElement();
                this.qio.setDataSource(dataSource);
            } else {
                System.out.println("              configured as basic web project");
            }
        }

        private void setQioDbAttributes() throws Exception {
            this.validateDatasource();
            this.checkInitDevDb();
        }

        private void dispatchEvent() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Method setupComplete;
            if (this.qio.getEvents() != null && (setupComplete = this.qio.getEvents().getClass().getDeclaredMethod("setupComplete", Qio.class)) != null) {
                setupComplete.setAccessible(true);
                setupComplete.invoke(this.qio.getEvents(), this.qio);
            }
        }

        private void runElementsProcessor() throws Exception {
            ElementProcessor elementsProcessor = new ElementProcessor(this.qio).run();
            this.qio.setElementProcessor(elementsProcessor);
        }

        private void runConfigProcessor() throws Exception {
            if (this.qio.getElementProcessor().getConfigs() != null && this.qio.getElementProcessor().getConfigs().size() > 0) {
                new ConfigurationProcessor(this.qio).run();
            }
        }

        private void runAnnotationProcessor() throws Exception {
            new AnnotationProcessor(this.qio).run();
        }

        private void runEndpointProcessor() throws Exception {
            Qio.command("        [+]   processing endpoints");
            EndpointProcessor endpointProcessor = new EndpointProcessor(this.qio).run();
            EndpointMappings endpointMappings = endpointProcessor.getMappings();
            this.qio.setEndpointMappings(endpointMappings);
        }

        private void runPropertiesProcessor() throws Exception {
            if (!this.qio.getPropertiesFiles().isEmpty()) {
                new PropertiesProcessor(this.qio).run();
            }
        }

        private void runInstanceProcessor() throws Exception {
            new InstanceProcessor(this.qio).run();
        }

        private void runProcessors() throws Exception {
            this.runPropertiesProcessor();
            this.runInstanceProcessor();
            this.runElementsProcessor();
            this.runConfigProcessor();
            this.runAnnotationProcessor();
            this.runEndpointProcessor();
        }

        private void sayReady() {
            Qio.command("        [+]   project ready \u2713");
            Qio.command("        [+]   Go to \u001b[1;33mhttp://localhost:port" + this.qio.getServletContext().getContextPath() + "\u001b[0m\n\n\n\n\n");
        }

        public Initializer build() throws Exception {
            this.qio.sign();
            this.setQioAttributes();
            this.runProcessors();
            this.setQioDbAttributes();
            this.sayReady();
            this.dispatchEvent();
            return new Initializer();
        }
    }
}

