/*
 * Decompiled with CFR 0.152.
 */
package qio.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StaticResource {
    String uri;
    ServletContext context;
    HttpServletResponse resp;

    public StaticResource(String uri, ServletContext context, HttpServletResponse resp) {
        this.uri = uri;
        this.context = context;
        this.resp = resp;
    }

    public void serve() {
        try {
            String filename = this.context.getRealPath(this.uri);
            String mime = this.context.getMimeType(filename);
            if (mime == null) {
                this.resp.setStatus(500);
                return;
            }
            this.resp.setContentType(mime);
            File file = new File(filename);
            this.resp.setContentLength((int)file.length());
            FileInputStream in = new FileInputStream(file);
            ServletOutputStream out = this.resp.getOutputStream();
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = in.read(buf)) >= 0) {
                out.write(buf, 0, count);
            }
            out.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static Boolean isResource(String uri, List<String> resources) {
        String asset;
        if (resources == null) {
            return false;
        }
        String[] parts = uri.split("/");
        if (parts.length > 1 && resources.contains(asset = parts[1])) {
            return true;
        }
        return false;
    }
}

