/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.amqp.AmqpProperties;
import dev.snowdrop.vertx.amqp.AmqpPropertiesConverter;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpClient;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.core.Vertx;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AmqpProperties.class})
@ConditionalOnBean(value={Vertx.class})
@ConditionalOnProperty(prefix="vertx.amqp", value={"enabled"}, matchIfMissing=true)
public class AmqpAutoConfiguration {
    @Bean
    public AmqpClient amqpClient(Vertx vertx, AmqpProperties properties) {
        AmqpPropertiesConverter propertiesConverter = new AmqpPropertiesConverter();
        AmqpClientOptions options = propertiesConverter.toAmqpClientOptions(properties);
        return new SnowdropAmqpClient(this.getMutinyAmqpClient(vertx, options), new MessageConverter());
    }

    private io.vertx.mutiny.core.Vertx getMutinyVertx(Vertx vertx) {
        return new io.vertx.mutiny.core.Vertx(vertx);
    }

    private io.vertx.mutiny.amqp.AmqpClient getMutinyAmqpClient(Vertx vertx, AmqpClientOptions options) {
        return io.vertx.mutiny.amqp.AmqpClient.create((io.vertx.mutiny.core.Vertx)this.getMutinyVertx(vertx), (AmqpClientOptions)options);
    }
}

