/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk;

import com.smartbear.har.builder.HarContentBuilder;
import com.smartbear.har.builder.HarCookieBuilder;
import com.smartbear.har.builder.HarEntryBuilder;
import com.smartbear.har.builder.HarHeaderBuilder;
import com.smartbear.har.builder.HarPostDataBuilder;
import com.smartbear.har.builder.HarRequestBuilder;
import com.smartbear.har.builder.HarResponseBuilder;
import com.smartbear.har.creator.DefaultHarStreamWriter;
import com.smartbear.har.model.HarContent;
import com.smartbear.har.model.HarCookie;
import com.smartbear.har.model.HarCreator;
import com.smartbear.har.model.HarHeader;
import com.smartbear.har.model.HarRequest;
import com.smartbear.har.model.HarResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class SpeakeasyHarBuilder {
    private final String cookieResponseHeaderName = "Set-Cookie";
    private final DefaultHarStreamWriter.Builder harWriterBuilder = new DefaultHarStreamWriter.Builder();
    private OutputStream outputStream;
    private String comment;
    private Date startTime;
    private String hostName;
    private String port;
    private HarCreator creator;
    private HarRequest harRequest;
    private HarResponse harResponse;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return this.port;
    }

    public HarCreator getCreator() {
        return this.creator;
    }

    public HarRequest getHarRequest() {
        return this.harRequest;
    }

    public HarResponse getHarResponse() {
        return this.harResponse;
    }

    public SpeakeasyHarBuilder withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public SpeakeasyHarBuilder withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public SpeakeasyHarBuilder withPort(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    public SpeakeasyHarBuilder withRequest(ContentCachingRequestWrapper request) throws UnsupportedEncodingException {
        List<Object> harCookieList = new ArrayList();
        if (request.getCookies() != null) {
            harCookieList = Arrays.stream(request.getCookies()).map(c -> {
                HarCookie harCookie = new HarCookieBuilder().withComment(c.getComment()).withDomain(c.getDomain()).withExpires(String.valueOf(c.getMaxAge())).withHttpOnly(c.isHttpOnly()).withName(c.getName()).withPath(c.getPath()).withSecure(c.getSecure()).withValue(c.getValue()).build();
                return harCookie;
            }).collect(Collectors.toList());
        }
        ArrayList<HarHeader> harHeaderList = new ArrayList<HarHeader>();
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String cookieRequestHeaderName;
            String name = headerNames.nextElement();
            if (name.equalsIgnoreCase(cookieRequestHeaderName = "Cookie")) {
                Enumeration<String> cookieValues = request.getHeaders(name);
                while (cookieValues.hasMoreElements()) {
                    harCookieList.add(this.parseCookieString(cookieValues.nextElement()));
                }
                continue;
            }
            harHeaderList.add(new HarHeaderBuilder().withName(name).withValues(Collections.list(request.getHeaders(name))).build());
        }
        String queryString = StringUtils.hasText(request.getQueryString()) ? request.getQueryString() : "";
        this.harRequest = new HarRequestBuilder().withPostData(new HarPostDataBuilder().withMimeType(request.getContentType()).withText(new String(request.getContentAsByteArray())).build()).withBodySize(request.getContentLengthLong()).withCookies(harCookieList).withHeaders(harHeaderList).withHeadersSize(-1L).withHttpVersion(request.getProtocol()).withMethod(request.getMethod()).withQueryString(queryString).withUrl(request.getRequestURI()).build();
        return this;
    }

    public SpeakeasyHarBuilder withResponse(ContentCachingResponseWrapper response) {
        List<HarCookie> harCookieList = response.getHeaderNames().stream().filter(header -> "Set-Cookie".equals(header)).flatMap(headerName -> response.getHeaders((String)headerName).stream().map(hv -> this.parseCookieString((String)hv))).collect(Collectors.toList());
        List<HarHeader> harHeaderList = response.getHeaderNames().stream().filter(header -> !"Set-Cookie".equals(header)).map(headerName -> new HarHeaderBuilder().withName((String)headerName).withValues(new ArrayList<String>(response.getHeaders((String)headerName))).build()).collect(Collectors.toList());
        HarContent harContent = new HarContentBuilder().withSize(Long.valueOf(response.getContentSize())).withText(new String(response.getContentAsByteArray())).withMimeType(response.getContentType()).build();
        this.harResponse = new HarResponseBuilder().withStatus(response.getStatus()).withStatusText(HttpStatus.valueOf(response.getStatus()).name()).withCookies(harCookieList).withContent(harContent).withBodySize(Long.valueOf(response.getContentSize())).withHeaders(harHeaderList).withHeadersSize(-1L).build();
        return this;
    }

    public SpeakeasyHarBuilder withOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public SpeakeasyHarBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public SpeakeasyHarBuilder withCreator(HarCreator creator) {
        this.creator = creator;
        return this;
    }

    private HarCookie parseCookieString(String cookie) {
        String cookieHeaderPrefix = "Set-Cookie=";
        if (cookie.startsWith(cookieHeaderPrefix)) {
            cookie = cookie.substring(cookieHeaderPrefix.length());
        }
        HarCookieBuilder cookieBuilder = new HarCookieBuilder();
        String cookieRegex = "([^=]+)=([^\\;]+);\\s?";
        Pattern pattern = Pattern.compile(cookieRegex);
        Matcher matcher = pattern.matcher(cookie);
        block14: while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            switch (key.toLowerCase()) {
                case "domain": {
                    cookieBuilder.withDomain(value);
                    continue block14;
                }
                case "expires": {
                    cookieBuilder.withExpires(value);
                    continue block14;
                }
                case "httponly": {
                    cookieBuilder.withHttpOnly("true".equalsIgnoreCase(value));
                    continue block14;
                }
                case "path": {
                    cookieBuilder.withPath(value);
                    continue block14;
                }
                case "secure": {
                    cookieBuilder.withSecure("true".equalsIgnoreCase(value));
                    continue block14;
                }
            }
            cookieBuilder.withName(key);
            cookieBuilder.withValue(value);
        }
        return cookieBuilder.build();
    }

    public void build() throws IOException {
        DefaultHarStreamWriter harWriter = this.harWriterBuilder.withOutputStream(this.outputStream).withComment(this.comment).withCreator(this.creator).build();
        harWriter.addEntry(new HarEntryBuilder().withConnection(this.port).withRequest(this.harRequest).withResponse(this.harResponse).withServerIPAddress(this.hostName).withStartedDateTime(this.startTime).withTime(new Date().getTime()).build());
        harWriter.closeHar();
    }
}

