package dev.speakeasyapi.sdk;

import java.io.ByteArrayOutputStream;
import java.time.Instant;

import org.slf4j.Logger;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import com.smartbear.har.model.HarCreator;

import dev.speakeasyapi.sdk.client.ISpeakeasyClient;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SpeakeasyRequestResponseHandler {
    private final String sdkName = "speakeasy-jvm-springboot-sdk";
    private final String speakeasyVersion = "1.1.0";
    private ISpeakeasyClient speakeasyClient;
    private Logger logger;

    public SpeakeasyRequestResponseHandler(ISpeakeasyClient speakeasyClient, Logger logger) {
        this.speakeasyClient = speakeasyClient;
        this.logger = logger;
    }

    public void captureRequestResponse(HttpServletRequest request,
                                       ByteArrayOutputStream requestOutputStream,
                                       HttpServletResponse response,
                                       ByteArrayOutputStream responseOutputStream,
            Instant startTime, Instant endTime, String pathHint, String customerID) {
        UriComponents uriComponents = UriComponentsBuilder
                .fromUriString(request.getRequestURI())
                .build();

        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        try {
            new SpeakeasyHarBuilder()
                    .withStartTime(startTime)
                    .withEndTime(endTime)
                    .withComment(String.format("request capture for %s", request.getRequestURI()))
                    .withCreator(new HarCreator(sdkName, "", speakeasyVersion))
                    .withHostName(uriComponents.getHost())
                    .withOutputStream(outputStream)
                    .withPort(uriComponents.getPort())
                    .withRequest(request, requestOutputStream, logger)
                    .withResponse(response, responseOutputStream, request.getProtocol(), logger)
                    .build();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("speakeasy-sdk: Failed to build Har file: %s", e);
            return;
        }

        String harString = new String(outputStream.toByteArray());
        try {
            speakeasyClient.ingestGrpc(harString, pathHint, customerID);
        } catch (Exception e) {

            logger.error("speakeasy-sdk: Failed to ingest request:", e);
        }
    }
}
