package dev.speakeasyapi.sdk.utils;

import dev.speakeasyapi.accesstokens.Embedaccesstoken;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import dev.speakeasyapi.sdk.models.SpeakeasyEmbedAccessTokenRequestBuilder;

import javax.net.ssl.SSLException;

public class SpeakeasyMiddlewareController {
    private String pathHint;
    private String customerID;
    private final ISpeakeasyClient client;

    public SpeakeasyMiddlewareController(ISpeakeasyClient client) {
        this.client = client;
    }

    public void setPathHint(String pathHint) {
        this.pathHint = pathHint;
    }

    public String getPathHint() {
        return pathHint;
    }

    public void setCustomerID(String customerID) {
        this.customerID = customerID;
    }

    public String getCustomerID() {
        return customerID;
    }

    public String getEmbedAccessToken(Embedaccesstoken.EmbedAccessTokenRequest request)
            throws RuntimeException {
        return client.getEmbedAccessToken(request).getAccessToken();
    }
}
