/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import com.google.inject.Inject;
import dev.voidframework.cache.engine.AbstractCacheEngine;
import dev.voidframework.core.bindable.BindClass;
import dev.voidframework.redis.Redis;

@BindClass
public class RedisCacheEngine
extends AbstractCacheEngine {
    private final Redis redis;

    @Inject
    public RedisCacheEngine(Redis redis) {
        this.redis = redis;
    }

    public Object get(String cacheKey) {
        AbstractCacheEngine.CachedElement cachedElement = (AbstractCacheEngine.CachedElement)this.redis.get(cacheKey, AbstractCacheEngine.CachedElement.class);
        return this.unwrap(cachedElement);
    }

    public void set(String cacheKey, Object value, int timeToLive) {
        if (value != null) {
            AbstractCacheEngine.CachedElement cachedElement = this.wrap(value);
            this.redis.set(cacheKey, AbstractCacheEngine.CachedElement.class, (Object)cachedElement, timeToLive);
        }
    }

    public void remove(String cacheKey) {
        this.redis.remove(cacheKey);
    }
}

