/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.validation;

import dev.voidframework.validation.ValidationError;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Validated<T> {
    private final T instance;
    private final Map<String, List<ValidationError>> validationErrorPerPathMap;

    Validated(T instance, Map<String, List<ValidationError>> validationErrorPerPathMap) {
        this.instance = instance;
        this.validationErrorPerPathMap = validationErrorPerPathMap != null ? validationErrorPerPathMap : new HashMap();
    }

    public static <T> Validated<T> emptyOf() {
        return new Validated<Object>(null, new HashMap<String, List<ValidationError>>());
    }

    public static <T> Validated<T> emptyOf(T instance) {
        return new Validated<T>(instance, new HashMap<String, List<ValidationError>>());
    }

    public boolean hasError() {
        return !this.validationErrorPerPathMap.isEmpty();
    }

    public boolean hasError(String path) {
        List<ValidationError> validationErrorList = this.validationErrorPerPathMap.get(path);
        return validationErrorList != null && !validationErrorList.isEmpty();
    }

    public boolean isValid() {
        return this.validationErrorPerPathMap.isEmpty();
    }

    public Map<String, List<ValidationError>> getError() {
        return this.validationErrorPerPathMap;
    }

    public ValidationError getError(String path) {
        List<ValidationError> validationErrorList = this.validationErrorPerPathMap.get(path);
        return validationErrorList == null ? null : validationErrorList.get(0);
    }

    public List<ValidationError> getErrorList(String path) {
        List<ValidationError> validationErrorList = this.validationErrorPerPathMap.get(path);
        return validationErrorList == null ? Collections.emptyList() : validationErrorList;
    }

    public T getInstance() {
        return this.instance;
    }
}

