/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.validation.validator.impl;

import dev.voidframework.validation.validator.InputStreamSize;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSizeImpl
implements ConstraintValidator<InputStreamSize, InputStream> {
    private InputStreamSize constraintAnnotation;

    public void initialize(InputStreamSize constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(InputStream value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            long availableBytes = value.available();
            return availableBytes >= this.constraintAnnotation.min() && availableBytes <= this.constraintAnnotation.max();
        }
        catch (IOException ignore) {
            return false;
        }
    }
}

