package zio.aws.cloudhsmv2.model
import scala.jdk.CollectionConverters.*
sealed trait BackupPolicy {
  def unwrap: software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy
}
object BackupPolicy {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy
  ): zio.aws.cloudhsmv2.model.BackupPolicy = value match {
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy.DEFAULT =>
      val r = DEFAULT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudhsmv2.model.BackupPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.cloudhsmv2.model.BackupPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy.DEFAULT
  }
}
