package zio.aws.cloudhsmv2.model
import scala.jdk.CollectionConverters.*
sealed trait BackupRetentionType {
  def unwrap
      : software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType
}
object BackupRetentionType {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType
  ): zio.aws.cloudhsmv2.model.BackupRetentionType = value match {
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType.DAYS =>
      val r = DAYS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudhsmv2.model.BackupRetentionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType.UNKNOWN_TO_SDK_VERSION
  }
  case object DAYS extends zio.aws.cloudhsmv2.model.BackupRetentionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionType.DAYS
  }
}
