package zio.aws.cloudhsmv2.model
import scala.jdk.CollectionConverters.*
sealed trait BackupState {
  def unwrap: software.amazon.awssdk.services.cloudhsmv2.model.BackupState
}
object BackupState {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsmv2.model.BackupState
  ): zio.aws.cloudhsmv2.model.BackupState = value match {
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.BackupState.PENDING_DELETION =>
      val r = PENDING_DELETION
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudhsmv2.model.BackupState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupState =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.BackupState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupState =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupState.CREATE_IN_PROGRESS
  }
  case object READY extends zio.aws.cloudhsmv2.model.BackupState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupState =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupState.READY
  }
  case object DELETED extends zio.aws.cloudhsmv2.model.BackupState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupState =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupState.DELETED
  }
  case object PENDING_DELETION extends zio.aws.cloudhsmv2.model.BackupState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.BackupState =
      software.amazon.awssdk.services.cloudhsmv2.model.BackupState.PENDING_DELETION
  }
}
