package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{BackupId, Region}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyBackupToRegionRequest(
    destinationRegion: Region,
    backupId: BackupId,
    tagList: Optional[Iterable[zio.aws.cloudhsmv2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest = {
    import CopyBackupToRegionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest
      .builder()
      .destinationRegion(Region.unwrap(destinationRegion): java.lang.String)
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest.wrap(buildAwsValue())
}
object CopyBackupToRegionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest =
      zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest(
        destinationRegion,
        backupId,
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def destinationRegion: Region
    def backupId: BackupId
    def tagList: Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getDestinationRegion: ZIO[Any, Nothing, Region] =
      ZIO.succeed(destinationRegion)
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest
  ) extends zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest.ReadOnly {
    override val destinationRegion: Region =
      zio.aws.cloudhsmv2.model.primitives.Region(impl.destinationRegion())
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
    override val tagList
        : Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest
  ): zio.aws.cloudhsmv2.model.CopyBackupToRegionRequest.ReadOnly = new Wrapper(
    impl
  )
}
