package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{IpAddress, ExternalAz, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHsmRequest(
    clusterId: ClusterId,
    availabilityZone: ExternalAz,
    ipAddress: Optional[IpAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest = {
    import CreateHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .availabilityZone(ExternalAz.unwrap(availabilityZone): java.lang.String)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CreateHsmRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.CreateHsmRequest.wrap(buildAwsValue())
}
object CreateHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CreateHsmRequest =
      zio.aws.cloudhsmv2.model.CreateHsmRequest(
        clusterId,
        availabilityZone,
        ipAddress.map(value => value)
      )
    def clusterId: ClusterId
    def availabilityZone: ExternalAz
    def ipAddress: Optional[IpAddress]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getAvailabilityZone: ZIO[Any, Nothing, ExternalAz] =
      ZIO.succeed(availabilityZone)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest
  ) extends zio.aws.cloudhsmv2.model.CreateHsmRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.cloudhsmv2.model.primitives.ClusterId(impl.clusterId())
    override val availabilityZone: ExternalAz =
      zio.aws.cloudhsmv2.model.primitives.ExternalAz(impl.availabilityZone())
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.cloudhsmv2.model.primitives.IpAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest
  ): zio.aws.cloudhsmv2.model.CreateHsmRequest.ReadOnly = new Wrapper(impl)
}
