package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHsmResponse(
    hsm: Optional[zio.aws.cloudhsmv2.model.Hsm] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse = {
    import CreateHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse
      .builder()
      .optionallyWith(hsm.map(value => value.buildAwsValue()))(_.hsm)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CreateHsmResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.CreateHsmResponse.wrap(buildAwsValue())
}
object CreateHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CreateHsmResponse =
      zio.aws.cloudhsmv2.model
        .CreateHsmResponse(hsm.map(value => value.asEditable))
    def hsm: Optional[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]
    def getHsm: ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Hsm.ReadOnly] =
      AwsError.unwrapOptionField("hsm", hsm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse
  ) extends zio.aws.cloudhsmv2.model.CreateHsmResponse.ReadOnly {
    override val hsm: Optional[zio.aws.cloudhsmv2.model.Hsm.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsm())
        .map(value => zio.aws.cloudhsmv2.model.Hsm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse
  ): zio.aws.cloudhsmv2.model.CreateHsmResponse.ReadOnly = new Wrapper(impl)
}
