package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteBackupResponse(
    backup: Optional[zio.aws.cloudhsmv2.model.Backup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse = {
    import DeleteBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.DeleteBackupResponse.wrap(buildAwsValue())
}
object DeleteBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DeleteBackupResponse =
      zio.aws.cloudhsmv2.model
        .DeleteBackupResponse(backup.map(value => value.asEditable))
    def backup: Optional[zio.aws.cloudhsmv2.model.Backup.ReadOnly]
    def getBackup
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse
  ) extends zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly {
    override val backup: Optional[zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backup())
        .map(value => zio.aws.cloudhsmv2.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse
  ): zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly = new Wrapper(impl)
}
