package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{IpAddress, EniId, HsmId, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteHsmRequest(
    clusterId: ClusterId,
    hsmId: Optional[HsmId] = Optional.Absent,
    eniId: Optional[EniId] = Optional.Absent,
    eniIp: Optional[IpAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest = {
    import DeleteHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        hsmId.map(value => HsmId.unwrap(value): java.lang.String)
      )(_.hsmId)
      .optionallyWith(
        eniId.map(value => EniId.unwrap(value): java.lang.String)
      )(_.eniId)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DeleteHsmRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DeleteHsmRequest.wrap(buildAwsValue())
}
object DeleteHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DeleteHsmRequest =
      zio.aws.cloudhsmv2.model.DeleteHsmRequest(
        clusterId,
        hsmId.map(value => value),
        eniId.map(value => value),
        eniIp.map(value => value)
      )
    def clusterId: ClusterId
    def hsmId: Optional[HsmId]
    def eniId: Optional[EniId]
    def eniIp: Optional[IpAddress]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getHsmId: ZIO[Any, AwsError, HsmId] =
      AwsError.unwrapOptionField("hsmId", hsmId)
    def getEniId: ZIO[Any, AwsError, EniId] =
      AwsError.unwrapOptionField("eniId", eniId)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest
  ) extends zio.aws.cloudhsmv2.model.DeleteHsmRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.cloudhsmv2.model.primitives.ClusterId(impl.clusterId())
    override val hsmId: Optional[HsmId] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.HsmId(value))
    override val eniId: Optional[EniId] = zio.aws.core.internal
      .optionalFromNullable(impl.eniId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.EniId(value))
    override val eniIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.eniIp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.IpAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest
  ): zio.aws.cloudhsmv2.model.DeleteHsmRequest.ReadOnly = new Wrapper(impl)
}
