package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeBackupsResponse(
    backups: Optional[Iterable[zio.aws.cloudhsmv2.model.Backup]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse = {
    import DescribeBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse
      .builder()
      .optionallyWith(
        backups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.DescribeBackupsResponse.wrap(buildAwsValue())
}
object DescribeBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DescribeBackupsResponse =
      zio.aws.cloudhsmv2.model.DescribeBackupsResponse(
        backups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backups: Optional[List[zio.aws.cloudhsmv2.model.Backup.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getBackups
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Backup.ReadOnly]] =
      AwsError.unwrapOptionField("backups", backups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse
  ) extends zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly {
    override val backups
        : Optional[List[zio.aws.cloudhsmv2.model.Backup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Backup.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse
  ): zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
