package zio.aws.cloudhsmv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{ClustersMaxSize, NextToken, Field}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeClustersRequest(
    filters: Optional[Map[Field, Iterable[String]]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ClustersMaxSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              (Field.unwrap(key): java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ClustersMaxSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DescribeClustersRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DescribeClustersRequest.wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DescribeClustersRequest =
      zio.aws.cloudhsmv2.model.DescribeClustersRequest(
        filters.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[Map[Field, List[String]]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ClustersMaxSize]
    def getFilters: ZIO[Any, AwsError, Map[Field, List[String]]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ClustersMaxSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest
  ) extends zio.aws.cloudhsmv2.model.DescribeClustersRequest.ReadOnly {
    override val filters: Optional[Map[Field, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cloudhsmv2.model.primitives
                .Field(key) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
    override val maxResults: Optional[ClustersMaxSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClustersMaxSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest
  ): zio.aws.cloudhsmv2.model.DescribeClustersRequest.ReadOnly = new Wrapper(
    impl
  )
}
