package zio.aws.cloudhsmv2.model
import scala.jdk.CollectionConverters.*
sealed trait HsmState {
  def unwrap: software.amazon.awssdk.services.cloudhsmv2.model.HsmState
}
object HsmState {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsmv2.model.HsmState
  ): zio.aws.cloudhsmv2.model.HsmState = value match {
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DEGRADED =>
      val r = DEGRADED
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.CREATE_IN_PROGRESS
  }
  case object ACTIVE extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.ACTIVE
  }
  case object DEGRADED extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DEGRADED
  }
  case object DELETE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.cloudhsmv2.model.HsmState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.HsmState =
      software.amazon.awssdk.services.cloudhsmv2.model.HsmState.DELETED
  }
}
