package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{Cert, ClusterId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InitializeClusterRequest(
    clusterId: ClusterId,
    signedCert: Cert,
    trustAnchor: Cert
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest = {
    import InitializeClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .signedCert(Cert.unwrap(signedCert): java.lang.String)
      .trustAnchor(Cert.unwrap(trustAnchor): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.InitializeClusterRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.InitializeClusterRequest.wrap(buildAwsValue())
}
object InitializeClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.InitializeClusterRequest =
      zio.aws.cloudhsmv2.model
        .InitializeClusterRequest(clusterId, signedCert, trustAnchor)
    def clusterId: ClusterId
    def signedCert: Cert
    def trustAnchor: Cert
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getSignedCert: ZIO[Any, Nothing, Cert] = ZIO.succeed(signedCert)
    def getTrustAnchor: ZIO[Any, Nothing, Cert] = ZIO.succeed(trustAnchor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest
  ) extends zio.aws.cloudhsmv2.model.InitializeClusterRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.cloudhsmv2.model.primitives.ClusterId(impl.clusterId())
    override val signedCert: Cert =
      zio.aws.cloudhsmv2.model.primitives.Cert(impl.signedCert())
    override val trustAnchor: Cert =
      zio.aws.cloudhsmv2.model.primitives.Cert(impl.trustAnchor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest
  ): zio.aws.cloudhsmv2.model.InitializeClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
