package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.BackupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModifyBackupAttributesRequest(
    backupId: BackupId,
    neverExpires: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest = {
    import ModifyBackupAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .neverExpires(neverExpires: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudhsmv2.model.ModifyBackupAttributesRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.ModifyBackupAttributesRequest.wrap(buildAwsValue())
}
object ModifyBackupAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ModifyBackupAttributesRequest =
      zio.aws.cloudhsmv2.model
        .ModifyBackupAttributesRequest(backupId, neverExpires)
    def backupId: BackupId
    def neverExpires: Boolean
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getNeverExpires: ZIO[Any, Nothing, Boolean] = ZIO.succeed(neverExpires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest
  ) extends zio.aws.cloudhsmv2.model.ModifyBackupAttributesRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
    override val neverExpires: Boolean = impl.neverExpires(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest
  ): zio.aws.cloudhsmv2.model.ModifyBackupAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
