package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyBackupAttributesResponse(
    backup: Optional[zio.aws.cloudhsmv2.model.Backup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse = {
    import ModifyBackupAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse
      .wrap(buildAwsValue())
}
object ModifyBackupAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse =
      zio.aws.cloudhsmv2.model
        .ModifyBackupAttributesResponse(backup.map(value => value.asEditable))
    def backup: Optional[zio.aws.cloudhsmv2.model.Backup.ReadOnly]
    def getBackup
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse
  ) extends zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly {
    override val backup: Optional[zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backup())
        .map(value => zio.aws.cloudhsmv2.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse
  ): zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
