package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.BackupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RestoreBackupRequest(backupId: BackupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest = {
    import RestoreBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.RestoreBackupRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.RestoreBackupRequest.wrap(buildAwsValue())
}
object RestoreBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.RestoreBackupRequest =
      zio.aws.cloudhsmv2.model.RestoreBackupRequest(backupId)
    def backupId: BackupId
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest
  ) extends zio.aws.cloudhsmv2.model.RestoreBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest
  ): zio.aws.cloudhsmv2.model.RestoreBackupRequest.ReadOnly = new Wrapper(impl)
}
