package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceId: ResourceId,
    tagList: Iterable[zio.aws.cloudhsmv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.TagResourceRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.TagResourceRequest =
      zio.aws.cloudhsmv2.model.TagResourceRequest(
        resourceId,
        tagList.map { item =>
          item.asEditable
        }
      )
    def resourceId: ResourceId
    def tagList: List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest
  ) extends zio.aws.cloudhsmv2.model.TagResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.cloudhsmv2.model.primitives.ResourceId(impl.resourceId())
    override val tagList: List[zio.aws.cloudhsmv2.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.cloudhsmv2.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest
  ): zio.aws.cloudhsmv2.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
