package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{TagKey, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceId: ResourceId,
    tagKeyList: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagKeyList(tagKeyList.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.UntagResourceRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.UntagResourceRequest =
      zio.aws.cloudhsmv2.model.UntagResourceRequest(resourceId, tagKeyList)
    def resourceId: ResourceId
    def tagKeyList: List[TagKey]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagKeyList: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest
  ) extends zio.aws.cloudhsmv2.model.UntagResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.cloudhsmv2.model.primitives.ResourceId(impl.resourceId())
    override val tagKeyList: List[TagKey] = impl
      .tagKeyList()
      .asScala
      .map { item =>
        zio.aws.cloudhsmv2.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest
  ): zio.aws.cloudhsmv2.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
