package zio.aws.cloudhsmv2
import zio.aws.cloudhsmv2.model.primitives.{TagKey, Field, SubnetId, ExternalAz}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.cloudhsmv2.model.primitives.BackupId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BackupId extends Subtype[String]
    type BackupId = zio.aws.cloudhsmv2.model.primitives.BackupId.Type
    object BackupRetentionValue extends Subtype[String]
    type BackupRetentionValue =
      zio.aws.cloudhsmv2.model.primitives.BackupRetentionValue.Type
    object BackupsMaxSize extends Subtype[Int]
    type BackupsMaxSize =
      zio.aws.cloudhsmv2.model.primitives.BackupsMaxSize.Type
    object Cert extends Subtype[String]
    type Cert = zio.aws.cloudhsmv2.model.primitives.Cert.Type
    object ClusterId extends Subtype[String]
    type ClusterId = zio.aws.cloudhsmv2.model.primitives.ClusterId.Type
    object ClustersMaxSize extends Subtype[Int]
    type ClustersMaxSize =
      zio.aws.cloudhsmv2.model.primitives.ClustersMaxSize.Type
    object EniId extends Subtype[String]
    type EniId = zio.aws.cloudhsmv2.model.primitives.EniId.Type
    object ExternalAz extends Subtype[String]
    type ExternalAz = zio.aws.cloudhsmv2.model.primitives.ExternalAz.Type
    object Field extends Subtype[String]
    type Field = zio.aws.cloudhsmv2.model.primitives.Field.Type
    object HsmId extends Subtype[String]
    type HsmId = zio.aws.cloudhsmv2.model.primitives.HsmId.Type
    object HsmType extends Subtype[String]
    type HsmType = zio.aws.cloudhsmv2.model.primitives.HsmType.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.cloudhsmv2.model.primitives.IpAddress.Type
    object MaxSize extends Subtype[Int]
    type MaxSize = zio.aws.cloudhsmv2.model.primitives.MaxSize.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.cloudhsmv2.model.primitives.NextToken.Type
    object PreCoPassword extends Subtype[String]
    type PreCoPassword = zio.aws.cloudhsmv2.model.primitives.PreCoPassword.Type
    object Region extends Subtype[String]
    type Region = zio.aws.cloudhsmv2.model.primitives.Region.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.cloudhsmv2.model.primitives.ResourceId.Type
    object SecurityGroup extends Subtype[String]
    type SecurityGroup = zio.aws.cloudhsmv2.model.primitives.SecurityGroup.Type
    object StateMessage extends Subtype[String]
    type StateMessage = zio.aws.cloudhsmv2.model.primitives.StateMessage.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.cloudhsmv2.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.cloudhsmv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.cloudhsmv2.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.cloudhsmv2.model.primitives.Timestamp.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.cloudhsmv2.model.primitives.VpcId.Type
  }
  type Backups = List[zio.aws.cloudhsmv2.model.Backup]
  type Clusters = List[zio.aws.cloudhsmv2.model.Cluster]
  type ExternalSubnetMapping = Map[ExternalAz, SubnetId]
  type Filters = Map[Field, Iterable[String]]
  type Hsms = List[zio.aws.cloudhsmv2.model.Hsm]
  type Strings = List[String]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.cloudhsmv2.model.Tag]
}
