package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ActionExecutionId, ActionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionContext(
    name: Optional[ActionName] = Optional.Absent,
    actionExecutionId: Optional[ActionExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionContext = {
    import ActionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionContext
      .builder()
      .optionallyWith(
        name.map(value => ActionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        actionExecutionId.map(value =>
          ActionExecutionId.unwrap(value): java.lang.String
        )
      )(_.actionExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionContext.ReadOnly =
    zio.aws.codepipeline.model.ActionContext.wrap(buildAwsValue())
}
object ActionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionContext =
      zio.aws.codepipeline.model.ActionContext(
        name.map(value => value),
        actionExecutionId.map(value => value)
      )
    def name: Optional[ActionName]
    def actionExecutionId: Optional[ActionExecutionId]
    def getName: ZIO[Any, AwsError, ActionName] =
      AwsError.unwrapOptionField("name", name)
    def getActionExecutionId: ZIO[Any, AwsError, ActionExecutionId] =
      AwsError.unwrapOptionField("actionExecutionId", actionExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionContext
  ) extends zio.aws.codepipeline.model.ActionContext.ReadOnly {
    override val name: Optional[ActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.ActionName(value))
    override val actionExecutionId: Optional[ActionExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ActionExecutionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionContext
  ): zio.aws.codepipeline.model.ActionContext.ReadOnly = new Wrapper(impl)
}
