package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactLocationType {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType
}
object ArtifactLocationType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType
  ): zio.aws.codepipeline.model.ArtifactLocationType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ArtifactLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType =
      software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.codepipeline.model.ArtifactLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType =
      software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType.S3
  }
}
