package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait BlockerType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.BlockerType
}
object BlockerType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.BlockerType
  ): zio.aws.codepipeline.model.BlockerType = value match {
    case software.amazon.awssdk.services.codepipeline.model.BlockerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.BlockerType.SCHEDULE =>
      val r = Schedule
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.BlockerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.BlockerType =
      software.amazon.awssdk.services.codepipeline.model.BlockerType.UNKNOWN_TO_SDK_VERSION
  }
  case object Schedule extends zio.aws.codepipeline.model.BlockerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.BlockerType =
      software.amazon.awssdk.services.codepipeline.model.BlockerType.SCHEDULE
  }
}
