package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.WebhookName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWebhookRequest(name: WebhookName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest = {
    import DeleteWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest
      .builder()
      .name(WebhookName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.DeleteWebhookRequest.ReadOnly =
    zio.aws.codepipeline.model.DeleteWebhookRequest.wrap(buildAwsValue())
}
object DeleteWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.DeleteWebhookRequest =
      zio.aws.codepipeline.model.DeleteWebhookRequest(name)
    def name: WebhookName
    def getName: ZIO[Any, Nothing, WebhookName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest
  ) extends zio.aws.codepipeline.model.DeleteWebhookRequest.ReadOnly {
    override val name: WebhookName =
      zio.aws.codepipeline.model.primitives.WebhookName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest
  ): zio.aws.codepipeline.model.DeleteWebhookRequest.ReadOnly = new Wrapper(
    impl
  )
}
