package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  DisabledReason,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableStageTransitionRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    transitionType: zio.aws.codepipeline.model.StageTransitionType,
    reason: DisabledReason
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest = {
    import DisableStageTransitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .transitionType(transitionType.unwrap)
      .reason(DisabledReason.unwrap(reason): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.DisableStageTransitionRequest.ReadOnly =
    zio.aws.codepipeline.model.DisableStageTransitionRequest
      .wrap(buildAwsValue())
}
object DisableStageTransitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.DisableStageTransitionRequest =
      zio.aws.codepipeline.model.DisableStageTransitionRequest(
        pipelineName,
        stageName,
        transitionType,
        reason
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def transitionType: zio.aws.codepipeline.model.StageTransitionType
    def reason: DisabledReason
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getTransitionType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StageTransitionType] =
      ZIO.succeed(transitionType)
    def getReason: ZIO[Any, Nothing, DisabledReason] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest
  ) extends zio.aws.codepipeline.model.DisableStageTransitionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val transitionType
        : zio.aws.codepipeline.model.StageTransitionType =
      zio.aws.codepipeline.model.StageTransitionType.wrap(impl.transitionType())
    override val reason: DisabledReason =
      zio.aws.codepipeline.model.primitives.DisabledReason(impl.reason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest
  ): zio.aws.codepipeline.model.DisableStageTransitionRequest.ReadOnly =
    new Wrapper(impl)
}
