package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetActionTypeResponse(
    actionType: Optional[zio.aws.codepipeline.model.ActionTypeDeclaration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse = {
    import GetActionTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse
      .builder()
      .optionallyWith(actionType.map(value => value.buildAwsValue()))(
        _.actionType
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly =
    zio.aws.codepipeline.model.GetActionTypeResponse.wrap(buildAwsValue())
}
object GetActionTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetActionTypeResponse =
      zio.aws.codepipeline.model
        .GetActionTypeResponse(actionType.map(value => value.asEditable))
    def actionType
        : Optional[zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly]
    def getActionType: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly
    ] = AwsError.unwrapOptionField("actionType", actionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse
  ) extends zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly {
    override val actionType
        : Optional[zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value =>
          zio.aws.codepipeline.model.ActionTypeDeclaration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse
  ): zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
