package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{PipelineExecutionId, PipelineName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPipelineExecutionRequest(
    pipelineName: PipelineName,
    pipelineExecutionId: PipelineExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest = {
    import GetPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GetPipelineExecutionRequest.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineExecutionRequest.wrap(buildAwsValue())
}
object GetPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineExecutionRequest =
      zio.aws.codepipeline.model
        .GetPipelineExecutionRequest(pipelineName, pipelineExecutionId)
    def pipelineName: PipelineName
    def pipelineExecutionId: PipelineExecutionId
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest
  ) extends zio.aws.codepipeline.model.GetPipelineExecutionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest
  ): zio.aws.codepipeline.model.GetPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
