package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPipelineResponse(
    pipeline: Optional[zio.aws.codepipeline.model.PipelineDeclaration] =
      Optional.Absent,
    metadata: Optional[zio.aws.codepipeline.model.PipelineMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse = {
    import GetPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineResponse.wrap(buildAwsValue())
}
object GetPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineResponse =
      zio.aws.codepipeline.model.GetPipelineResponse(
        pipeline.map(value => value.asEditable),
        metadata.map(value => value.asEditable)
      )
    def pipeline
        : Optional[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly]
    def metadata: Optional[zio.aws.codepipeline.model.PipelineMetadata.ReadOnly]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ) extends zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly {
    override val pipeline
        : Optional[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value =>
          zio.aws.codepipeline.model.PipelineDeclaration.wrap(value)
        )
    override val metadata
        : Optional[zio.aws.codepipeline.model.PipelineMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.codepipeline.model.PipelineMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ): zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly = new Wrapper(impl)
}
