package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ClientToken, ThirdPartyJobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetThirdPartyJobDetailsRequest(
    jobId: ThirdPartyJobId,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest = {
    import GetThirdPartyJobDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest
      .builder()
      .jobId(ThirdPartyJobId.unwrap(jobId): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest.ReadOnly =
    zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest
      .wrap(buildAwsValue())
}
object GetThirdPartyJobDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest =
      zio.aws.codepipeline.model
        .GetThirdPartyJobDetailsRequest(jobId, clientToken)
    def jobId: ThirdPartyJobId
    def clientToken: ClientToken
    def getJobId: ZIO[Any, Nothing, ThirdPartyJobId] = ZIO.succeed(jobId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest
  ) extends zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest.ReadOnly {
    override val jobId: ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId(impl.jobId())
    override val clientToken: ClientToken =
      zio.aws.codepipeline.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest
  ): zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
