package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ArtifactName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InputArtifact(name: ArtifactName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.InputArtifact = {
    import InputArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.InputArtifact
      .builder()
      .name(ArtifactName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.InputArtifact.ReadOnly =
    zio.aws.codepipeline.model.InputArtifact.wrap(buildAwsValue())
}
object InputArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.InputArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.InputArtifact =
      zio.aws.codepipeline.model.InputArtifact(name)
    def name: ArtifactName
    def getName: ZIO[Any, Nothing, ArtifactName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.InputArtifact
  ) extends zio.aws.codepipeline.model.InputArtifact.ReadOnly {
    override val name: ArtifactName =
      zio.aws.codepipeline.model.primitives.ArtifactName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.InputArtifact
  ): zio.aws.codepipeline.model.InputArtifact.ReadOnly = new Wrapper(impl)
}
